<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
String path = request.getContextPath();
String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="<%= request.getContextPath()%>/resources/mta/css/myCenter.css" />
	<script src="<%= request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript" charset="utf-8"></script>
	<script type="text/javascript">
		var page_select_index=-1;
	</script>
</head>
<body>
	<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<div id="personalMain" class="w">
		<div id="leftNav" class="l">
			<c:import url="personalCenter.jsp"></c:import>
		</div>
		<div id="mainRight" class="r">
			<div class="title">
				<span class="title_back l"></span>
				<h2 class="l">
					<!-- 个人中心 -->
					<spring:message code="label.font.center"/>
				</h2>
			</div>
			<ul class="list">
				<li class="list1 l">
					<a href="<%= request.getContextPath()%>/mta/P020/myCourse.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的课程 -->
								<spring:message code="label.center.mycourse"/>
								<c:choose>
									<c:when test="${countMap.kccount == 0}">
									</c:when>
									<c:when test="${countMap.kccount > 0}">
										<span class="number">${countMap.kccount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list2 l">
					<a href="<%= request.getContextPath()%>/mta/P031/myExam.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的考试 -->
								<spring:message code="label.center.myexam"/>
								<c:choose>
									<c:when test="${countMap.kscount <= 0}">
									</c:when>
									<c:when test="${countMap.kscount > 0}">
										<span class="number">${countMap.kscount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list3 l">
					<a href="<%= request.getContextPath()%>/mta/P030/myResults.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的成绩 -->
								<spring:message code="label.center.myResults"/>
								<c:choose>
									<c:when test="${countMap.cjcount <= 0}">
									</c:when>
									<c:when test="${countMap.cjcount > 0}">
										<span class="number">${countMap.cjcount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list4 l">
					<a href="<%= request.getContextPath()%>/mta/P040/myResource.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的资源 -->
								<spring:message code="label.center.myResource"/>
								<c:choose>
									<c:when test="${countMap.zycount <= 0}">
									</c:when>
									<c:when test="${countMap.zycount > 0}">
										<span class="number">${countMap.zycount}</span>
									</c:when>
									
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list5 l">
					<a href="<%= request.getContextPath()%>/mta/P050/myAskanswer.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的问答 -->
								<spring:message code="label.center.myAskanswer"/>
								<c:choose>
									<c:when test="${countMap.wdcount <= 0}">
									</c:when>
									<c:when test="${countMap.wdcount > 0}">
										<span class="number">${countMap.wdcount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list6 l">
					<a href="<%= request.getContextPath()%>/mta/P060/myNote.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的笔记 -->
								<spring:message code="label.center.myNote"/>
								<c:choose>
									<c:when test="${countMap.bjcount <= 0}">
									</c:when>
									<c:when test="${countMap.bjcount > 0}">
										<span class="number">${countMap.bjcount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list7 l">
					<a href="<%= request.getContextPath()%>/mta/P070/myAppraise.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的评价 -->
								<spring:message code="label.center.myAppraise"/>
								<c:choose>
									<c:when test="${countMap.pjcount <= 0}">
									</c:when>
									<c:when test="${countMap.pjcount > 0}">
										<span class="number">${countMap.pjcount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list8 l">
					<a href="<%= request.getContextPath()%>/mta/P100/myExercise.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的练习 -->
								<spring:message code="label.center.myExercise"/>
								<c:choose>
									<c:when test="${countMap.lxcount <= 0}">
									</c:when>
									<c:when test="${countMap.lxcount > 0}">
										<span class="number">${countMap.lxcount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
				<li class="list9 l">
					<a href="<%= request.getContextPath()%>/mta/P090/myCertificate.html">
						<div class="img_box"></div>
						<h3 class="text">
							<span class="content">
								<!-- 我的证书-->
								<spring:message code="label.center.myCertificate"/>
								<c:choose>
									<c:when test="${countMap.zscount <= 0}">
									</c:when>
									<c:when test="${countMap.zscount > 0}">
										<span class="number">${countMap.zscount}</span>
									</c:when>
								</c:choose>
							</span>
						</h3>
					</a>
				</li>
			</ul>
		</div>
	</div>
	<div id="footer">
		<c:import url="footer.jsp"></c:import>
	</div>
</body>
</html>